/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.util.Utilities;

public class SceMp4AvcNalStruct
extends pspAbstractMemoryMappedStructure {
    public int spsBuffer;
    public int spsSize;
    public int ppsBuffer;
    public int ppsSize;
    public int nalPrefixSize;
    public int nalBuffer;
    public int nalSize;
    public int mode;

    @Override
    protected void read() {
        this.spsBuffer = this.read32();
        this.spsSize = this.read32();
        this.ppsBuffer = this.read32();
        this.ppsSize = this.read32();
        this.nalPrefixSize = this.read32();
        this.nalBuffer = this.read32();
        this.nalSize = this.read32();
        this.mode = this.read32();
    }

    @Override
    protected void write() {
        this.write32(this.spsBuffer);
        this.write32(this.spsSize);
        this.write32(this.ppsBuffer);
        this.write32(this.ppsSize);
        this.write32(this.nalPrefixSize);
        this.write32(this.nalBuffer);
        this.write32(this.nalSize);
        this.write32(this.mode);
    }

    @Override
    public int sizeof() {
        return 32;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.spsBuffer != 0 && this.spsSize > 0) {
            s.append(String.format("SPS Buffer: %s", Utilities.getMemoryDump(this.spsBuffer, this.spsSize)));
        }
        if (this.ppsBuffer != 0 && this.ppsSize > 0) {
            s.append(String.format(", PPS Buffer: %s", Utilities.getMemoryDump(this.ppsBuffer, this.ppsSize)));
        }
        s.append(String.format(", NAL prefix size 0x%X", this.nalPrefixSize));
        if (this.nalBuffer != 0 && this.nalSize > 0) {
            s.append(String.format(", NAL Buffer: %s", Utilities.getMemoryDump(this.nalBuffer, this.nalSize)));
        }
        s.append(String.format(", mode 0x%X", this.mode));
        return s.toString();
    }
}

